<?PHP  if ( ! defined('BASEPATH')) exit('No direct script access allowed'); 
/**
* @package direct-project-innovation-initiative
* @subpackage libraries
* @filesource
*/ /** */

require_once('Mail/RFC822.php');

/**
* @package direct-project-innovation-initiative
* @subpackage libraries
*/
class Mailformat {
	protected $CI;
	
	public function __construct(){
		$this->CI =& get_instance();
	}
	
	public function get_folder_list() {
		$group_mailboxes = $this->CI->session->userdata('group_mailboxes');
		$mailbox_group = $this->CI->session->userdata('mailbox_group');
		if($mailbox_group !== $this->CI->session->userdata('username')) {
			$valid_mailbox = FALSE;
			foreach($group_mailboxes as $key => $group) {
				if($mailbox_group === $key) { $valid_mailbox = TRUE; }
			}
			//if not a valid mailbox, force it back to the personal mailbox
			if(!$valid_mailbox) { $this->CI->session->set_userdata('mailbox_group',$this->session->userdata('username')); }
		}
		$resource = '/direct/folders/mailbox/'.$this->CI->session->userdata('mailbox_group');
		$resource .= '/format/json';
		return $this->CI->api_model->webservice_call($resource,'GET');
	}
	
	public function get_folder_count($folder) {
		$resource = '/direct/count/mailbox/'.$this->CI->session->userdata('username').'/folder/'.$folder;
		$resource .= '/format/json';
		return $this->CI->api_model->webservice_call($resource,'GET');
	}
	
	public function mailbox_list() {
		//determine the mailbox
		if(isset($this->CI->mailbox))
			$mailbox = $this->CI->mailbox;
		else
			$mailbox = Mailbox::find_one( array('user_name' => $this->CI->session->userdata('mailbox_group')));

		if(!Mailbox::is_an_entity($mailbox)) return false;

		//grab the folders for this mailbox
		$folders = $mailbox->folders;
		
		$folder_list = '<ul id="mailbox_list">';
		//display group name at top of mailbox list if relevant
		if($mailbox->is_group) {
			 $folder_list .= '<li class="nohover" title="'.$this->CI->session->userdata('mailbox_group_cn').'"><div style="text-overflow: ellipsis; overflow: hidden; white-space: nowrap;">' . 
			 				 $this->CI->session->userdata('mailbox_group_cn') . '</div></li>'; 
		}
		
		foreach($folders as $folder_id => $folder) {
			$show_unseen = '';
			if($folder_id == 'draft' && !$folder->property_is_empty('total')) { //for drafts
				$show_unseen = ' ('.$folder->total.')';
			}elseif(!$folder->property_is_empty('new')) {
				$show_unseen = ' ('.$folder->new.')';
			}			
			
			//create mailbox list components
			if($folder->is_custom_folder()){
				if($menuClass == 'systemFolder') { 
					$menuClass = 'firstCustomFolder';
					
						$folder_list .= '<li class="nohover"><span style="display:block; width:140px; margin-top:5px; height:1px; border-bottom:1px dotted #999;"></span></li>';
						$folder_list .= '<li class="systemFolder"><img src="/images/yellow_folder_add.png" alt="Create Folder Icon"/><a class="mbox" onclick= "createFolder();" href="#" title="Create Folder">Create Folder</a></li>';
						$add_create_folder = TRUE; //keep track of the fact we have create folder menu added
					
				} 
				else {  $menuClass = 'customFolder'; }
				
				//set custom folder menus
				$folder_hash = hash('sha256',($folder->name_for_display()));
				$menu = '<span id="' . $folder_hash . '" class="menu">&#9660;</span>';
				$menu .= '<span class="custom_folder_name" style="display: none;">' . $folder->name_for_display() . '</span>';
				$accessibility_menu = 	'<a id="archive_folder_'.$folder_hash.'" class="hidden_context" href="/inbox/archive_folder/'.rawurlencode(base64_encode($folder->name_for_display())).'">Archive Folder: '.$folder->name_for_display().'</a>'.
										form_hidden('old_value_'.$folder_hash, $folder->name_for_display(), 'old_value_'.$folder_hash).
										'<label id="rename_folder_label_'.$folder_hash.'" for="rename_folder_'.$folder_hash.'" class="hidden_context">Rename Folder</label>'.
										'<input class="hidden_context" name="rename_folder_'.$folder_hash.'" id="rename_folder_'.$folder_hash.'" type="button" value="Rename Folder" onclick="'.
                                        '$(\'[id=&quot;'.$folder_hash.'&quot;]\').parent().children(\'.custom_folder_name\').css(\'display\',\'inline\');'.
                                        '$(\'[id=&quot;'.$folder_hash.'&quot;]\').parent().children(\'a\').css(\'display\',\'none\');'.
                                        '$(\'[id=&quot;'.$folder_hash.'&quot;]\').parent().children(\'.custom_folder_name\').editable(\'/inbox/rename_folder/'.
                                        rawurlencode(base64_encode($folder->name_for_display())).'/\',{ event : \'rename_event\',height: 12,width: 100,style : \'position: relative; float: right; z-index: 100;\', submitdata: {\''.$this->CI->security->get_csrf_token_name().'\': $(\'input[type=&quot;hidden&quot;].token\').val()}, onblur : \'submit\',indicator : \'Saving...\' ,callback: function(value, settings) { $(this).unbind(settings.event);}});'.
                                        '$(\'[id=&quot;'.$folder_hash.'&quot;]\').parent().children(\'.custom_folder_name\').trigger(\'rename_event\');"/>';
			}
			else {
				//if system folder, don't set custom folder menus
				$menuClass = 'systemFolder'; 
				$menu = $accessibility_menu  = '';
			}

			//if there is a current mailbox stored in session
			$anchor_class = 'mbox';
			if($folder_id == $this->CI->session->mailbox_location()) { 
				//if this mailbox is the current mailbox, make it bold (if not, do not)
				$anchor_class = 'cur_mbox';
				$_SESSION['unseen'] = $folder->new;
				$_SESSION['folder_name'] = $folder->name_for_display();
			}

			$folder_list .= '<li class="' . $menuClass .'">' . 
							 '<img style="width: 15px; height: 15px;" src="/images/closed_folder_yellow_icon.png" alt="Folder Icon" />' . 
							 $menu .'<a title="'.$folder->name_for_display().$show_unseen.'" class="' . $anchor_class . '" href="' . base_url() . 'inbox/change_mailbox/' . 
							 rawurlencode(base64_encode($folder_id)) . '">' . $folder->name_for_display() . $show_unseen . '</a>';
			$folder_list .= '</li>';
			if(strlen($accessibility_menu) > 0) { $folder_list .= '<li class="customMailboxAccessibleMenu">'. $accessibility_menu .'</li>'; }	
		}
		if(strpos($folder_list,'createFolder') === FALSE) {
			$folder_list .= '<li class="nohover"><span style="display:block; width:140px; margin-top:5px; height:1px; border-bottom:1px dotted #999;"></span></li>';
			$folder_list .= '<li class="systemFolder"><img src="/images/yellow_folder_add.png" alt="Create Folder Icon"/><a class="mbox" onclick= "createFolder();" href="#" title="Create Folder">Create Folder</a></li>';
			$add_create_folder = TRUE;
		}
		$folder_list .= '</ul>';
		return $folder_list;
		
	}
	
	/* Function designed to strip out repetitive RE's and FWD's from a message subject. Will also replace the most recent RE or FWD
     * with FWD or RE (respectively) if necessary; e.g., forwarding the following message 
	 * RE: Some Subject Here 
	 * ...will instead result in
	 * FWD: Some Subject Here
	*/
	public function msg_subject_sanitize($msg_subject,$type){
		$new_subject = $msg_subject;
		//detect if this is the subject that is already a reply or forward
		$multiple_replies = 	(substr($msg_subject,0,3) == 'RE:') || (substr($msg_subject,0,3) == 'Re:') || 
								(substr($msg_subject,0,2) == 'Fw') || (substr($msg_subject,0,2) == 'FW');
								
		//Conditional offset to handle if there is a Re:/Fwd: of some sort already in the subject
		$offset=((substr($msg_subject,0,4) == 'FWD:') || (substr($msg_subject,0,4) == 'Fwd:')) ? 4 : ($multiple_replies? 3: 0);
		
		//remove previous Re: / Fwd: then add ours
		if($type == 'reply' || $type == 'replyall') { $new_subject = 'Re: '. trim(substr($msg_subject,$offset)); }
		else if($type == 'forward') { $new_subject = 'Fwd: ' . trim(substr($msg_subject,$offset)); }
		else { return $msg_subject; } //just return original subject if not a reply or forward
		
		return $new_subject;
	}
	
	public function display_address_for_send($address){
		if(!is_string($address)) return $this->error->should_be_a_string($address);
		if(empty($address)) return '';
		
		if(string_begins_with('(', $address))
			$address = "\"" . str_replace(" (","\" <",$address); 
		else 
			$address = str_replace("(","<",$address); 
		
		return str_replace(")",">",$address);
	}
	
	public function format_display_addresses_for_sending($addresses) {
		return array_map( array($this, 'display_address_for_send'), $addresses);
	}
	
	public function format_address_list_for_display($addresses) {
		if(!is_null($addresses) && !is_string($addresses)) return $this->CI->error->should_be_a_string($addresses);
		if(empty(trim($addresses))) return array();
				
		$formatted_addresses = array();
		foreach(Mail_RFC822::parseAddressList($addresses) as $address) {
			if(!empty($address->host) && $address->host == "MISSING_DOMAIN") unset($address->host);
			
			if(!empty($address->personal) && !empty($address->mailbox) && !empty($address->host)){ 
				$formatted_addresses[] = $address->personal . " (" . $address->mailbox . "@" . $address->host . ")";
			}elseif(!empty($address->mailbox) && !empty($address->host)){
				$formatted_addresses[] = $address->mailbox . "@" . $address->host;
			}elseif(!empty($address->personal)){ 
				return array($address->personal); 
			}elseif(!empty($address->mailbox)){
				return array($address->mailbox); 
			}elseif(!empty($address->host)){
				return array($address->host); 
			}
		}
		return $formatted_addresses;
	}
	

}
?>